import { Phone, Mail, MapPin } from 'lucide-react';
import { Button } from './ui/button';
import { Input } from './ui/input';
import { Textarea } from './ui/textarea';

export function Contact() {
  return (
    <section className="py-20 px-6 bg-gray-900 text-white">
      <div className="max-w-7xl mx-auto">
        <div className="grid lg:grid-cols-2 gap-16">
          <div>
            <h2 className="mb-6">Get In Touch</h2>
            <p className="text-gray-300 mb-8">
              Have questions? We'd love to hear from you. Send us a message and we'll respond as soon as possible.
            </p>
            
            <div className="space-y-6">
              <div className="flex items-start gap-4">
                <div className="w-12 h-12 bg-[#086A1C] rounded-lg flex items-center justify-center flex-shrink-0">
                  <Phone className="w-6 h-6" />
                </div>
                <div>
                  <h4 className="mb-1">Phone</h4>
                  <p className="text-gray-300">+44 7448 305095</p>
                  <p className="text-gray-400">Mon-Sat, 8AM-8PM</p>
                </div>
              </div>
              
              <div className="flex items-start gap-4">
                <div className="w-12 h-12 bg-[#086A1C] rounded-lg flex items-center justify-center flex-shrink-0">
                  <Mail className="w-6 h-6" />
                </div>
                <div>
                  <h4 className="mb-1">Email</h4>
                  <p className="text-gray-300">propertyparkuk@gmail.com</p>
                  <p className="text-gray-400">24/7 support</p>
                </div>
              </div>
              
              <div className="flex items-start gap-4">
                <div className="w-12 h-12 bg-[#086A1C] rounded-lg flex items-center justify-center flex-shrink-0">
                  <MapPin className="w-6 h-6" />
                </div>
                <div>
                  <h4 className="mb-1">Location</h4>
                  <p className="text-gray-300">16 Boundary House</p>
                  <p className="text-gray-400">Oxford, OX2 0JH</p>
                </div>
              </div>
            </div>
          </div>
          
          <div className="bg-white text-gray-900 p-8 rounded-lg">
            <form className="space-y-6">
              <div>
                <label htmlFor="name" className="block mb-2">Name</label>
                <Input id="name" placeholder="Your name" />
              </div>
              
              <div>
                <label htmlFor="email" className="block mb-2">Email</label>
                <Input id="email" type="email" placeholder="your@email.com" />
              </div>
              
              <div>
                <label htmlFor="message" className="block mb-2">Message</label>
                <Textarea id="message" placeholder="Your message..." rows={5} />
              </div>
              
              <Button className="w-full bg-[#086A1C] hover:bg-[#075517]">
                Send Message
              </Button>
            </form>
          </div>
        </div>
      </div>
    </section>
  );
}