import { Button } from './ui/button';
import logo from 'figma:asset/dc6efbaa4dbcd867c34aef6f92564bc0790e3375.png';

export function Header() {
  return (
    <header className="fixed top-0 left-0 right-0 z-50 bg-white/95 backdrop-blur-sm shadow-sm">
      <div className="max-w-7xl mx-auto px-6 py-4">
        <div className="flex items-center justify-between">
          <div className="flex items-center gap-3">
            <img src={logo} alt="Park Laundry Service" className="h-12" />
          </div>
          
          <nav className="hidden md:flex items-center gap-8">
            <a href="#services" className="text-gray-700 hover:text-[#086A1C] transition-colors">Services</a>
            <a href="#how-it-works" className="text-gray-700 hover:text-[#086A1C] transition-colors">How It Works</a>
            <a href="#pricing" className="text-gray-700 hover:text-[#086A1C] transition-colors">Pricing</a>
            <a href="#contact" className="text-gray-700 hover:text-[#086A1C] transition-colors">Contact</a>
          </nav>
          
          <Button className="bg-[#086A1C] hover:bg-[#075517]">
            Book Now
          </Button>
        </div>
      </div>
    </header>
  );
}