import { ImageWithFallback } from './figma/ImageWithFallback';
import { Button } from './ui/button';

export function Hero() {
  return (
    <section className="relative h-screen flex items-center justify-center overflow-hidden">
      <div className="absolute inset-0 z-0">
        <ImageWithFallback
          src="https://images.unsplash.com/photo-1761403460807-a89b7de9b4d3?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHxsYXVuZHJ5JTIwc2VydmljZSUyMGNsZWFufGVufDF8fHx8MTc2NjQyMjU4MXww&ixlib=rb-4.1.0&q=80&w=1080&utm_source=figma&utm_medium=referral"
          alt="Fresh laundry service"
          className="w-full h-full object-cover"
        />
        <div className="absolute inset-0 bg-black/50" />
      </div>
      
      <div className="relative z-10 text-center text-white max-w-4xl mx-auto px-6">
        <h1 className="mb-6">Park Laundry Service</h1>
        <p className="mb-4 text-xl opacity-90">
          We Collect. We Clean. We Care.
        </p>
        <p className="mb-8 text-lg opacity-90">
          Fresh, clean clothes delivered to your door. Save time and let us handle your laundry needs.
        </p>
        <div className="flex gap-4 justify-center flex-wrap">
          <Button size="lg" className="bg-[#086A1C] hover:bg-[#075517]">
            Schedule Pickup
          </Button>
          <Button size="lg" variant="outline" className="bg-white/10 border-white text-white hover:bg-white/20">
            View Pricing
          </Button>
        </div>
      </div>
    </section>
  );
}