import { ImageWithFallback } from './figma/ImageWithFallback';

const steps = [
  {
    number: '01',
    title: 'Schedule Pickup',
    description: 'Book a pickup time online or via our app. We offer flexible scheduling 7 days a week.'
  },
  {
    number: '02',
    title: 'We Clean',
    description: 'Our professionals wash, dry, and fold your clothes with care using premium detergents.'
  },
  {
    number: '03',
    title: 'Delivery',
    description: 'Receive your fresh, clean laundry delivered right to your doorstep on your chosen date.'
  }
];

export function HowItWorks() {
  return (
    <section className="py-20 px-6">
      <div className="max-w-7xl mx-auto">
        <div className="text-center mb-16">
          <h2 className="mb-4">How It Works</h2>
          <p className="text-gray-600 max-w-2xl mx-auto">
            Getting your laundry done has never been easier
          </p>
        </div>
        
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          <div className="space-y-8">
            {steps.map((step, index) => (
              <div key={index} className="flex gap-6">
                <div className="flex-shrink-0">
                  <div className="w-16 h-16 bg-[#086A1C] text-white rounded-full flex items-center justify-center">
                    {step.number}
                  </div>
                </div>
                <div>
                  <h3 className="mb-2">{step.title}</h3>
                  <p className="text-gray-600">{step.description}</p>
                </div>
              </div>
            ))}
          </div>
          
          <div className="rounded-lg overflow-hidden shadow-lg">
            <ImageWithFallback
              src="https://images.unsplash.com/photo-1761079976271-3a78f547ca67?crop=entropy&cs=tinysrgb&fit=max&fm=jpg&ixid=M3w3Nzg4Nzd8MHwxfHNlYXJjaHwxfHx3YXNoaW5nJTIwbWFjaGluZSUyMG1vZGVybnxlbnwxfHx8fDE3NjY0MjI1ODJ8MA&ixlib=rb-4.1.0&q=80&w=1080&utm_source=figma&utm_medium=referral"
              alt="Modern washing machines"
              className="w-full h-full object-cover"
            />
          </div>
        </div>
      </div>
    </section>
  );
}