import { Button } from './ui/button';

const pricingCategories = [
  {
    title: 'DUVET FEATHER/SYNTHETIC',
    items: [
      { name: 'Duvet - Synthetic Single', price: '£18.19' },
      { name: 'Duvet - Synthetic Double', price: '£23.09' },
      { name: 'Duvet - Synthetic King', price: '£24.79' },
      { name: 'Duvet - Synthetic Superking', price: '£29.69' },
      { name: 'Duvet - Feather Single', price: '£23.39' },
      { name: 'Duvet - Feather Double', price: '£26.19' },
      { name: 'Duvet - Feather King', price: '£31.19' },
      { name: 'Duvet - Feather Superking', price: '£35.19' }
    ]
  },
  {
    title: 'FLAT SHEETS',
    items: [
      { name: 'Flat Sheet - Single', price: '£3.89' },
      { name: 'Flat Sheet - Double', price: '£5.59' },
      { name: 'Flat Sheet - King', price: '£4.29' },
      { name: 'Flat Sheet - King/Superking', price: '£5.09' },
      { name: 'Flannelette - Single', price: '£3.49' },
      { name: 'Flannelette - Double', price: '£4.49' }
    ]
  },
  {
    title: 'COMFORTER & DUVETS',
    items: [
      { name: 'Duvet Cover - Single', price: '£4.19' },
      { name: 'Duvet Cover - Double', price: '£4.99' },
      { name: 'Duvet Cover - King Size', price: '£6.19' },
      { name: 'Duvet Cover - Superking', price: '£7.19' }
    ]
  },
  {
    title: 'SELF SERVICE',
    items: [
      { name: 'Hand Towels', price: '£1.29' },
      { name: 'Bath Towels', price: '£1.89' },
      { name: 'Bath Sheet', price: '£2.39' },
      { name: 'Bath Mats', price: '£1.99' }
    ]
  },
  {
    title: 'KITCHEN SERVICE',
    items: [
      { name: 'Aprons', price: '£1.29' },
      { name: 'Chef Jacket', price: '£1.89' },
      { name: 'Table Covers', price: '£2.39' }
    ]
  },
  {
    title: 'OTHERS',
    items: [
      { name: 'Bedspread - Single', price: '£10.89' },
      { name: 'Pillowcase - Synthetic', price: '£1.49' },
      { name: 'Pillowcase - Feather', price: '£2.29' }
    ]
  }
];

export function Pricing() {
  return (
    <section className="py-20 px-6 bg-gray-50" id="pricing">
      <div className="max-w-7xl mx-auto">
        <div className="text-center mb-16">
          <h2 className="mb-4">Price List</h2>
          <p className="text-gray-600 max-w-2xl mx-auto">
            Transparent pricing for all our laundry services
          </p>
        </div>
        
        <div className="grid md:grid-cols-2 lg:grid-cols-3 gap-8 max-w-7xl mx-auto">
          {pricingCategories.map((category, index) => (
            <div 
              key={index} 
              className="bg-white rounded-lg p-6 shadow-sm hover:shadow-md transition-shadow"
            >
              <div className="mb-6 pb-4 border-b-2 border-[#086A1C]">
                <h3 className="text-[#086A1C]">{category.title}</h3>
              </div>
              
              <ul className="space-y-3">
                {category.items.map((item, itemIndex) => (
                  <li key={itemIndex} className="flex justify-between items-start gap-4">
                    <span className="text-gray-700 flex-1">{item.name}</span>
                    <span className="text-[#086A1C] font-medium whitespace-nowrap">{item.price}</span>
                  </li>
                ))}
              </ul>
            </div>
          ))}
        </div>

        <div className="mt-12 text-center">
          <Button className="bg-[#086A1C] hover:bg-[#075517]">
            Schedule a Pickup
          </Button>
        </div>
      </div>
    </section>
  );
}