import { Sparkles, Clock, Droplet, Zap } from 'lucide-react';

const services = [
  {
    icon: Sparkles,
    title: 'Wash & Fold',
    description: 'Professional washing and folding service. Your clothes come back fresh and neatly organized.',
    price: 'From £1.29/item'
  },
  {
    icon: Clock,
    title: 'Express Service',
    description: 'Need it fast? Get your laundry cleaned and delivered within 24 hours.',
    price: 'From £3.89/item'
  },
  {
    icon: Droplet,
    title: 'Dry Cleaning',
    description: 'Expert dry cleaning for delicate fabrics and formal wear. Gentle care guaranteed.',
    price: 'From £18.19'
  },
  {
    icon: Zap,
    title: 'Commercial Laundry',
    description: 'Bulk laundry services for businesses, hotels, and restaurants. Volume discounts available.',
    price: 'Custom pricing'
  }
];

export function Services() {
  return (
    <section className="py-20 px-6 bg-gray-50">
      <div className="max-w-7xl mx-auto">
        <div className="text-center mb-16">
          <h2 className="mb-4">Our Services</h2>
          <p className="text-gray-600 max-w-2xl mx-auto">
            We offer a complete range of laundry services to meet all your needs
          </p>
        </div>
        
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
          {services.map((service, index) => {
            const Icon = service.icon;
            return (
              <div key={index} className="bg-white p-6 rounded-lg shadow-sm hover:shadow-md transition-shadow">
                <div className="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mb-4">
                  <Icon className="w-6 h-6 text-[#086A1C]" />
                </div>
                <h3 className="mb-2">{service.title}</h3>
                <p className="text-gray-600 mb-4">{service.description}</p>
                <p className="text-[#086A1C]">{service.price}</p>
              </div>
            );
          })}
        </div>
      </div>
    </section>
  );
}