import { Truck, Shield, Star, Clock } from 'lucide-react';

const benefits = [
  {
    icon: Truck,
    title: 'Free Pickup & Delivery',
    description: 'Convenient doorstep service with no extra charges for pickup and delivery.'
  },
  {
    icon: Shield,
    title: 'Quality Guarantee',
    description: 'We stand behind our work. If you\'re not satisfied, we\'ll rewash for free.'
  },
  {
    icon: Star,
    title: 'Premium Care',
    description: 'Top-quality detergents and fabric softeners for the best clean possible.'
  },
  {
    icon: Clock,
    title: 'Flexible Schedule',
    description: 'Book pickups and deliveries at times that work for your busy schedule.'
  }
];

export function WhyChooseUs() {
  return (
    <section className="py-20 px-6">
      <div className="max-w-7xl mx-auto">
        <div className="text-center mb-16">
          <h2 className="mb-4">Why Choose Us</h2>
          <p className="text-gray-600 max-w-2xl mx-auto">
            Experience the difference with our professional laundry service
          </p>
        </div>
        
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
          {benefits.map((benefit, index) => {
            const Icon = benefit.icon;
            return (
              <div key={index} className="text-center">
                <div className="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mx-auto mb-4">
                  <Icon className="w-8 h-8 text-[#086A1C]" />
                </div>
                <h3 className="mb-2">{benefit.title}</h3>
                <p className="text-gray-600">{benefit.description}</p>
              </div>
            );
          })}
        </div>
      </div>
    </section>
  );
}